//
//  MCApplication.h
//  MCApplication
//
//  Created by mclark on Wed Jul 25 2001.
//  Copyright (c) 2001 __CompanyName__. All rights reserved.
//

#import <AppKit/AppKit.h>

#import "MCApplicationDefines.h"

#import "MCMenuBuilder.h"
#import "MCMenuFault.h"

#import "MCPluginControllerRegistry.h"
#import "MCPluginController.h"

#import "MCProgressPanel.h"

#import "MCSurveyor.h"
#import "MCDataContextRegistry.h"
//#import "MCJavaLoader.h"

#import "MCToolbarBuilder.h"
#import "MCController+ToolbarAdditions.h"


#import "MCChannel.h"
#import "MCTee.h"
#import "MCTeeArray.h"
#import "MCBinder.h"
#import "MCSwitchView.h"
#import "MCAMD.h"
#import "MCTableviewController.h"
#import "MCPopupController.h"
#import "MCBrowserController.h"
#import "MCPListModelLoader.h"


#import "MCCellController.h"
#import "MCCellControllerPopulator.h"
#import "MCCellControllerProtocol.h"

#import "MCView.h"
#import "MCTableView.h"
#import "MCOutlineView.h"
#import "MCTableColumn.h"
#import "MCScrollView.h"
#import "MCColorWell.h"
#import "NSView+MCAdditions.h"
#import "MCSplitView.h"
#import "MCGridView.h"
#import "MCObjectSummaryView.h"

#import "MCController.h"
#import "MCWindowController.h"
#import "MCModelEditor.h"
#import "MCModelList.h"
#import "MCModelListFilter.h"


#import "MCSelectionCenter.h"
#import "MCInspectorCenter.h"
#import "MCInspectorControl.h"
#import "MCInspector.h"

#import "NSColor+MCAAdditions.h"
#import "NSAttributedString+MCAAdditions.h"
#import "NSBezierPath+MCAdditions.h"
#import "NSImage+MCAdditions.h"
#import "NSWindow+Morphing.h"
#import "NSDocument+MCAdditions.h"
#import "NSTextField+MCAdditions.h"
#import "NSApplication+MCAddditions.h"
#import "NSPrintInfo+MCAdditions.h"
#import "NSToolbarItem+MCAdditions.h"
#import "NSString+MCAAdditions.h"


#import "MCKeyInterceptWindow.h"

#import "MCBorderlessCenteredWindow.h"
#import "NSTextField+LargeWindowDisplay.h"


// Nib Based printing
#import "MCNibPrintingDefines.h"
#import "MCNibPrintView.h"
#import "MCMultiNibPrintController.h"
#import "MCNibPrintPageController.h"
#import "MCDefaultTablePrintControl.h"
#import "MCPrintWindowController.h"
#import "MCMarginAccessory.h"

#import "MCNibLoadingView.h"


#import "MCTimePopups.h"


#import "MCPoofAnimator.h"
#import "MCTransparentButton.h"

#import "OAAppleScript.h"


// Formatters
#import "MCPhoneNumberFormatter.h"

// AutoDialer
#import "MCAutoDialer.h"

// Widgets
#import "MCSingleFieldWindow.h"
#import "MCSimpleProgressBarWindow.h"

// Application Updates
#import "MCApplicationUpdater.h"

// Query Controller
#import "MCQueryController.h"

// Toolbar 
#import "MCToolbarItem.h"

// Report
#import "MCReportTemplateManager.h"

// Table Column subclass
#import "MCMixedDataCellTableColumn.h"

// Automator support
#import "PTAutomatorWorkflow.h"

// List/Membership Views And Support
#import "CTBadge.h"
#import "CTGradient.h"

#import "ECBinder.h"

#import "MCListRow.h"
#import "MCListView.h"
#import "MCMembershipListView.h"

#import "MCAnimationContext.h"

#import "MCHelpController.h"

@interface MCApplication : NSApplication {
    BOOL                    _isInDebugMode;
	BOOL					_isFirstRun;
	BOOL                    _isTerminating;


	
	NSString *cachedURLHandlerParameter;

	// An array of dictionaries, each dictionary describing a command they wish to be executed on the document upon connection
	// This is useful when the user has to first log in before something that was initiated when Daylite was not running can be run
	// I.e. they double clicked on a file of a type that requires a document to be handled by Daylite
	// Apps should subscribe to the document did open notif and process these commands themselves if they so desire
	// The dictionary structure is:
	// Key="Selector"  value=<$string value for the selector to be executed$>
	// Key="Arguments" value=<$array of objects to be passed to the command in the invocation$>
	NSMutableArray *cachedDocumentCommands; 
	
	IBOutlet NSMenuItem *listMenuItem;
	IBOutlet NSMenuItem *detailMenuItem;
	
	NSMenuItem *undoMenuItem;
	NSMenuItem *redoMenuItem;
	
	NSThread *_applicationMainThread;
}

+ (BOOL)isRunningOnSnowLeopardOrLater;
+ (BOOL)isRunningOnLeopard;
+ (BOOL)isRunningOnPanther;
+ (BOOL)isRunningOnTiger;

// Looks for MainMenu.strings to localize (called from awakeFromNib). Subclassers can override if different behavior is preferred
- (void)autoLocalize;

/*!
 Used by subclassers for any kind of version (solo, normal, pro) related adds or removes. Called during awakeFromNib before autoLocalize. Default implementation does nothing.
 Added by AJ 2009-10-17.
 */
- (void)prepareForAppFlavor;



// if a minor error happens, then this email is used to send email (from the alert panel that show up on something like an unknown selector
- (NSString *)crashReportEmailAddress;

- (BOOL)closeAllEditingWindowControllers;

- (BOOL)isInDebugMode;

// subclasses set it
- (BOOL)isFirstRun;

- (NSArray *)sheets;
- (void)endAllSheets;

- (void)terminate:(id)sender checkForEditingWindowControllers:(BOOL)shouldCheck;

- (NSString *)appIconName;

- (void)badgeDockIconWithCount:(int)count;

- (BOOL)isTerminating;
- (void)setIsTerminating:(BOOL)flag;

- (NSMenuItem *)listMenuItem;
- (NSMenuItem *)detailMenuItem;

- (void)quitAndRestart;

-(NSThread *)applicationMainThread;

- (void)windowDidBecomeKeyNotif:(NSNotification *)notif;

#pragma mark URLHandler
- (void)handleURLCommandWithParameter:(NSString *)param;

- (NSString *)cachedURLHandlerParameter;
- (void)setCachedURLHandlerParameter:(NSString *)aCachedURLHandlerParameter;

#pragma mark UndoRedoMenuItems
- (void)injectUndoAndRedoMenuItems;
- (void)removeUndoAndRedoMenuItems;



#pragma mark Accessors
- (NSMenuItem *)undoMenuItem;
- (void)setUndoMenuItem:(NSMenuItem *)anUndoMenuItem;
- (NSMenuItem *)redoMenuItem;
- (void)setRedoMenuItem:(NSMenuItem *)aRedoMenuItem;

- (NSMutableArray *)cachedDocumentCommands;
- (void)setCachedDocumentCommands:(NSMutableArray *)aCachedDocumentCommands;
@end
